const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { COURSE_DELIVERY } = require("../../models/tables");

const getCourseDeliveryService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, COURSE_DELIVERY), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getCourseDeliveryPaginationService = async (query) => {
  try {
    const result = await getCourseDeliveryService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, COURSE_DELIVERY), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewCourseDeliveryService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, COURSE_DELIVERY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCourseDeliveryService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, COURSE_DELIVERY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCourseDeliveryService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, COURSE_DELIVERY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCourseDeliveryService,
  getCourseDeliveryPaginationService,
  addNewCourseDeliveryService,
  updateCourseDeliveryService,
  deleteCourseDeliveryService,
}