const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { COURSELEVEL } = require("../../models/tables");

const getCourseLevelService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, COURSELEVEL), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getCourseLevelPaginationService = async (query) => {
  try {
    const result = await getCourseLevelService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, COURSELEVEL), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewCourseLevelService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, COURSELEVEL), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCourseLevelService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, COURSELEVEL), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCourseLevelService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, COURSELEVEL), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCourseLevelService,
  getCourseLevelPaginationService,
  addNewCourseLevelService,
  updateCourseLevelService,
  deleteCourseLevelService,
}