const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { EXAM_LEVEL_TYPE } = require("../../models/tables");

const getExamLevelService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, EXAM_LEVEL_TYPE), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getExamLevelPaginationService = async (query) => {
  try {
    const result = await getExamLevelService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, EXAM_LEVEL_TYPE), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewExamLevelService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, EXAM_LEVEL_TYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateExamLevelService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, EXAM_LEVEL_TYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteExamLevelService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, EXAM_LEVEL_TYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getExamLevelService,
  getExamLevelPaginationService,
  addNewExamLevelService,
  updateExamLevelService,
  deleteExamLevelService,
}