const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { TBL_NPF_API,NPF_COURSE_MASTER,NPF_RESPONSE, STUDY_INDIA } = require("../../models/tables");

const getNPFService = async (query) => {
  try {    
    
  
    const result = await dbQuery(getSqlQuery(query, TBL_NPF_API), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};



const getNPFServiceindividual = async (query) => {
  try {    
    const result = await dbQuery(getSqlQuery(query, NPF_RESPONSE), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};


const getNPFLeadsService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, NPF_RESPONSE), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};




const getNPFCS = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, NPF_COURSE_MASTER), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getNPFPaginationService = async (query) => {
  try {
    const result = await getNPFService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, TBL_NPF_API), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};


const getNPFIndividualPaginationService = async (query) => {
  try {
    const result = await getNPFServiceindividual(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, NPF_RESPONSE), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};


const getNPFleadsPaginationService = async (query) => {
  try {
    const result = await getNPFLeadsService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, NPF_RESPONSE), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const getNPFCourseServices = async (query) => {
  try {
    const result = await getNPFCS(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, NPF_COURSE_MASTER), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewCourseService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCourseService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCourseService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getNPFService,
  getNPFPaginationService,
  getNPFCourseServices,
  addNewCourseService,
  updateCourseService,
  deleteCourseService,
  getNPFleadsPaginationService,
  getNPFIndividualPaginationService
}