const { dbQuery, getSqlQuery, addSqlQuery, deleteSqlQuery, updateSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { SCHOOL_FACILITY } = require("../../models/tables");

const getSchoolFacilityService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SCHOOL_FACILITY), query.parameters);
    if(!result){
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}

const getSchoolFacilityPaginationService = async (query) => {
  try {
    const result = await getSchoolFacilityService(query);
    if(result instanceof Error){
      return { result: [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, SCHOOL_FACILITY), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error)
  }
}

const addNewSchoolFacilityService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, SCHOOL_FACILITY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateSchoolFacilityService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, SCHOOL_FACILITY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteSchoolFacilityService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, SCHOOL_FACILITY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getSchoolFacilityService,
  addNewSchoolFacilityService,
  deleteSchoolFacilityService,
  updateSchoolFacilityService,
  getSchoolFacilityPaginationService,
};