const { dbQuery, getSqlQuery, addSqlQuery, deleteSqlQuery, updateSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { SCHOOLTYPE } = require("../../models/tables");

const getSchoolTypeService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SCHOOLTYPE), query.parameters);
    if(!result){
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}

const getSchoolTypePaginationService = async (query) => {
  try {
    const result = await getSchoolTypeService(query);
    if(result instanceof Error){
      return { result: [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, SCHOOLTYPE), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error)
  }
}

const addNewSchoolTypeService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, SCHOOLTYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateSchoolTypeService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, SCHOOLTYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteSchoolTypeService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, SCHOOLTYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getSchoolTypeService,
  addNewSchoolTypeService,
  deleteSchoolTypeService,
  updateSchoolTypeService,
  getSchoolTypePaginationService,
};