const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { SPECIALIZATION } = require("../../models/tables");

const getSpecializationService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SPECIALIZATION), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getSpecializationPaginationService = async (query) => {
  try {
    const result = await getSpecializationService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, SPECIALIZATION), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewSpecializationService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, SPECIALIZATION), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateSpecializationService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, SPECIALIZATION), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteSpecializationService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, SPECIALIZATION), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getSpecializationService,
  getSpecializationPaginationService,
  addNewSpecializationService,
  updateSpecializationService,
  deleteSpecializationService,
}