const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../config/db.config");
const { SC_USER } = require("../models/tables")

const getScUserService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SC_USER), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getScUserPaginationService = async (query) => {
  try {
    const result = await getScUserService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, SC_USER), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewScUserService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, SC_USER), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateScUserService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, SC_USER), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteScUserService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, SC_USER), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getScUserService,
  getScUserPaginationService,
  addNewScUserService,
  updateScUserService,
  deleteScUserService,
}