const { dbQuery, getSqlQuery, getSqlQueryForCount, addSqlQuery, deleteSqlQuery, updateSqlQuery } = require("../config/db.config");
const { SC_SCHOOL_CONTENT, SCHOOL_DETAIL, TBL_AWARDS, TBL_ACCORDION_CONTENT,TBL_SCHOOL_GRADE_FEE, SC_SCHOOLLOCATIONMASTER } = require("../models/tables");

const getSchoolDetailsService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SCHOOL_DETAIL), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getSchoolDetailsPaginationService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SCHOOL_DETAIL), query.parameters);
    if(result instanceof Error){
      return { result: [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, SCHOOL_DETAIL), query.parameters);
    return { result, total:total[0].total }
  } catch (error) {
    throw new Error(error)
  }
}

const addNewSchoolService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, SCHOOL_DETAIL), query.parameters);
    if(!result.affectedRows){
      return new Error("Error while new School")
    }
    return result;
  } catch (error) {
    throw new Error(error)
  }
}

const updateSchoolService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, SCHOOL_DETAIL), query.parameters);
    if(!result.affectedRows){
      return new Error("School not updated")
    }
    return result;
  } catch (error) {
    throw new Error(error)
  }
}

const deleteSchoolService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, SCHOOL_DETAIL), query.parameters);
    if(!result.affectedRows){
      return new Error("Error while deleting school")
    }
  } catch (error) {
    throw new Error(error)
  }
}

const getSchoolContentService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SC_SCHOOL_CONTENT), query.parameters)
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getSchoolAwardsService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, TBL_AWARDS), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};


const getSchoolGradeFeeService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, TBL_SCHOOL_GRADE_FEE), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getSchoolFaqService = async (query) => {
  try {
    
    const result = await dbQuery(getSqlQuery(query, TBL_ACCORDION_CONTENT), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}


const getCityLocaltiesService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SC_SCHOOLLOCATIONMASTER), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}


const getcitybystate = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, SCHOOL_DETAIL), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}

const getsimilarschools = async (query) => {
   
   
  try {
    const result = await dbQuery(getSqlQuery(query, SCHOOL_DETAIL), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}




module.exports = {
  getSchoolDetailsService,
  getSchoolContentService,
  getSchoolAwardsService,
  getSchoolFaqService,
  getSchoolDetailsPaginationService,
  addNewSchoolService,
  deleteSchoolService,
  updateSchoolService,
  getSchoolGradeFeeService,
  getCityLocaltiesService,
  getsimilarschools,
  getcitybystate
};
