const splitByUnderscoresAndCapitalize = (text) => {
  if (text.length === 0) return "";
  return `${text[0].toUpperCase()}${text
    .toLowerCase()
    .split("_")
    .join(" ")
    .substring(1)}`; // capitalize first letter.
};

const addByUnderscoresAndLowercase = (text) => {
  if (text.length === 0) return "";
  return `${text[0].toLowerCase()}${text
    .toLowerCase()
    .split(" ")
    .join("_")
    .substring(1)}`; // lower case first letter.
}

function areAllKeysPresent(obj, keys) {
  return keys.every((key) => obj.hasOwnProperty(key));
}

module.exports = {
  splitByUnderscoresAndCapitalize,
  addByUnderscoresAndLowercase,
  areAllKeysPresent,
};
