"use strict";
const { dbQuery } = require("../config/db.config");
const {
  BUYER,
  SCL_STUDENT,
  CLG_STUDENT,
  SCHOOL,
  COLLEGE,
} = require("../common/constants");
const {
  C_INSTITUTE,
  SC_USER,
  SCHOOL_DETAIL,
  TBL_SCHOOL_SHORTLIST,
  STUDY_INDIA,
  TBL_SCHOOL_GRADE_FEE,
  TBL_STUDENT_CART,
  TBL_SCHOOL_STUDENT,
  C_COURSE,
  NPF_COURSE_MASTER,
  NPF_RESPONSE
} = require("../models/tables");
const { getSchoolDetailsService } = require("../services/school.service");
const axios = require('axios');

const schoolTbl = SCHOOL_DETAIL;
const collegeTbl = C_INSTITUTE;
const leadTbl = SC_USER;
const buyerTbl = SC_USER;
const shortlistTbl = TBL_SCHOOL_SHORTLIST;
const generalEnquiryTbl = STUDY_INDIA;
const schoolGradeFeesTbl = TBL_SCHOOL_GRADE_FEE;
const cartTbl = TBL_STUDENT_CART;
const childTbl = TBL_SCHOOL_STUDENT;
const collegeCourseTbl = C_COURSE;
const schoolQueryTbl = STUDY_INDIA;
const npf_course_master = NPF_COURSE_MASTER;



const checkLeadExistInDatabase = async (id) => {
  try {
    let [sql, result] = [null, null];
    sql = `SELECT us_id FROM ${leadTbl} WHERE us_id = ? LIMIT 1`;
    result = await dbQuery(sql, [id]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkLeadAlreadyExist = async (email, type = "school") => {
  try {
    let [sql, result] = [null, null];
    // sql = `SELECT us_id FROM ${leadTbl} WHERE (email_1 = ? OR us_username = ?) AND user_type = ? LIMIT 1`;
    sql = `SELECT us_id FROM ${leadTbl} WHERE (email_1 = ? OR us_username = ?)  LIMIT 1`;
    result = await dbQuery(sql, [email, email, type]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};


/////////////////// Commented by shani added bu shani/////////////////


const getotherorchidschoolbycity = async (city) => {
  try {
    // console.log("sid",sid)
    let [sql, result] = [null, null];
    // sql = `SELECT ${desiredata} FROM ${table} WHERE ${filterby} = ? LIMIT 1`;
    // sql = `select sid from school_detail where  admission_partner='Y' and school_name like '%Orchid%' and city like  '%${city}%'   order by rand() limit 1`;
    sql=`select eid from tbl_npf_api where  active='Y' and college_name like '%Orchid%' and city like  '%${city}%'  order by rand() limit 1`
    result = await dbQuery(sql);
    if (result.length) return result[0];
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
}



const getlastinsertidforNPF = async (desiredata,table,filterby,email) => {
  try {
    // console.log("sid",sid)
    let [sql, result] = [null, null];
    sql = `SELECT ${desiredata} as insertid FROM ${table} WHERE ${filterby} = ? order by ${desiredata} desc LIMIT 1`;
    result = await dbQuery(sql,[email]);
    if (result.length) return result[0];
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
}

const getSinglevalueByid = async (desiredata,table,filterby,id) => {
  try {
    // console.log("sid",sid)
    let [sql, result] = [null, null];
    sql = `SELECT ${desiredata} FROM ${table} WHERE ${filterby} = ? LIMIT 1`;
    result = await dbQuery(sql,[id]);
    if (result.length) return result[0];
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
}

// UPDATE sc_user SET npf_response = CONCAT(npf_response,'sdadadd') WHERE us_id= 37468;

// update sc_user set npf_response=CONCAT_WS(',',npf_response,'{"msg":"success","InsertId":7414,"date":"2024-07-16T17:16:09.000Z"}') WHERE us_id= 37528

const OpenApplyResponseUpdate = async (updatecol,table,updatekey,updateid,response) => {
  // let strresponse= JSON.stringify(response)
  let strresponse=''
  if(response.msg=='success')
  {
    strresponse= 'OA:'+response.msg
  }
  try {
    let [sql, result] = [null, null];
    sql = `update ${table} set ${updatecol}=CONCAT_WS(',',${updatecol},'${strresponse}')   WHERE ${updatekey}= ? `;
    result = await dbQuery(sql,[updateid]);
    if (result.length) return result[0];
    return false;
  } catch (error) {
    throw new Error("Some error occured while updatinf info" + error);
  }
  }



  const NPFResponseUpdatebytable = async (updatecol,table,updatekey,updateid,response) => {
    // let strresponse= JSON.stringify(response)

    let strresponse=''
    if(response.status)
    {
    strresponse= response.status
    }
    else
    {
      strresponse= JSON.stringify(response)
    }
    try {
      let [sql, result] = [null, null];
      sql = `update ${table} set ${updatecol}='${strresponse}'  WHERE ${updatekey}= ? `;
       
      result = await dbQuery(sql,[updateid]);
      
      if (result.length) return result[0];
      return false;
    } catch (error) {
      throw new Error("Some error occured while updatinf info" + error);
    }
    }
  


  const NPFResponseUpdate = async (request,response,table,studentid,instituteid,instname) => {
    let strresponse= JSON.stringify(response)
    let strrequest= JSON.stringify(request)
    try {
      let [sql, result] = [null, null];
      sql = `insert into ${NPF_RESPONSE} (data,response,table_name,primary_id,e_id,inst_name,date) value(?,?,?,?,?,?,NOW()) `;

       
      result = await dbQuery(sql,[strrequest,strresponse,table,studentid,instituteid,instname]);
      if (result.length) return result[0];
      return false;
    } catch (error) {
      throw new Error("Some error occured while updatinf info" + error);
    }
    }



    const getschoolemailbyid = async (sid) => {
      try {
        // console.log("sid",sid)
        let [sql, result] = [null, null];
        sql = `SELECT contact_email_address as emailids, school_name FROM ${SCHOOL_DETAIL} WHERE sid = ?`;
        result = await dbQuery(sql,[sid]);
        if (result.length) return result[0];
        return false;
      } catch (error) {
        throw new Error("Some error occured while fetching info" + error);
      }
    }
 
///////////////////////////////////////////////////////////////////////



const checkBuyerInstituteAccess = async (id, instituteId) => {
  try {
    const institute_type = await getBuyersInstituteType(id);
    let [sql, result] = [null, null];
    if (!id || !instituteId || !institute_type)
      throw new Error("Invalid request");
    switch (institute_type) {
      case SCHOOL:
        sql = `SELECT sid FROM ${schoolTbl} WHERE buyer_name = ? AND sid = ? LIMIT 1`;
        break;
      case COLLEGE:
        sql = `SELECT e_id FROM ${collegeTbl} WHERE buyer_name = ? AND e_id = ? LIMIT 1`;
        break;
      default:
        throw new Error("Invalid request");
    }
    result = await dbQuery(sql, [id, instituteId]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkBuyerSchoolExist = async (schoolId, id) => {
  try {
    let [sql, result] = [null, null];
    sql = `SELECT sid, buyer_name FROM ${schoolTbl} WHERE sid = ? LIMIT 1`;
    result = await dbQuery(sql, [schoolId]);
    if (result.length === 0) throw new Error("School not found");
    const { buyer_name: buyerId } = result[0];
    if (!buyerId) {
      return true;
    }
    if (buyerId == id) {
      return true;
    } else {
      return false;
    }
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkBuyerExist = async (buyerId) => {
  try {
    let [sql, result] = [null, null];
    sql = `SELECT us_id FROM ${buyerTbl} WHERE us_id = ? AND user_type = ? LIMIT 1`;
    result = await dbQuery(sql, [buyerId, BUYER]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkExportPermission = async (id) => {
  try {
    let [sql, result] = [null, null];
    sql = `SELECT export_data FROM ${buyerTbl} WHERE us_id = ? AND user_type = ? LIMIT 1`;
    result = await dbQuery(sql, [id, BUYER]);
    if (!result[0]) throw new Error("Unauthorised Access, Buyer not found");
    const { export_data: permission } = result[0];
    switch (permission) {
      case "Y":
        return true;
      case "N":
        return false;
    }
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkCollegeExist = async (eid) => {
  try {
    let [sql, result] = [null, null];
    if (!eid) throw new Error("No college Id");
    sql = `SELECT ${collegeTbl}.e_id FROM ${collegeTbl} WHERE ${collegeTbl}.e_id = ? LIMIT 1`;
    result = await dbQuery(sql, [eid]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const getCollegeIdBasedOnUrl = async (url) => {
  try {
    let [sql, result] = [null, null];
    if (!url) throw new Error("No college url");
    sql = `SELECT ${collegeTbl}.e_id FROM ${collegeTbl} WHERE ${collegeTbl}.institute_url = ? LIMIT 1`;
    result = await dbQuery(sql, [url]);
    if (result.length) return result[0].e_id;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkSchoolShortlistExist = async (sid) => {
  try {
    let [sql, result] = [null, null];
    if (!sid) throw new Error("No school Id");
    const attributes = [`${schoolTbl}.sid`, `${schoolTbl}.admission_partner`];
    sql = `SELECT ${attributes.join(
      ", "
    )} FROM ${schoolTbl} WHERE sid = ? LIMIT 1`;
    result = await dbQuery(sql, [sid]);
    if (!result[0]) throw new Error("School doesn't exist with this Id");
    const { admission_partner: partner } = result[0];
    switch (partner) {
      case "Y":
        return true;
      case "N":
        throw new Error(
          "This school is not Partnered with All School Colleges, cannot shortlist it"
        );
      default:
        throw new Error("School doesn't exist or is not a partner with us");
    }
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkSchoolExist = async (sid, isPartner = null) => {
  try {
    let [sql, result] = [null, null];
    if (!sid) throw new Error("No school Id");
    let qry = "";
    const attributes = [`${schoolTbl}.sid`];
    const insertBody = [sid];
    if (isPartner) {
      qry = ` AND ${schoolTbl}.admission_partner = ?`;
      attributes.push(`${schoolTbl}.admission_partner`);
      insertBody.push(isPartner);
    }
    sql = `SELECT ${attributes.join(
      ", "
    )} FROM ${schoolTbl} WHERE sid = ? ${qry} LIMIT 1`;
    result = await dbQuery(sql, insertBody);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkLeadShortlistAlreadyExist = async (school_id, us_id, type,courseid) => {
  try {
    let [sql, result] = [null, null];
    switch (type) {
      case CLG_STUDENT:
        const doesCollegeExist = await checkCollegeExist(school_id);
        if (!doesCollegeExist)
          throw new Error("College doesn't exist with this Id");
        break;
      case SCL_STUDENT:
        const doesSchoolExist = await checkSchoolExist(school_id);
        if (!doesSchoolExist)
          throw new Error("School doesn't exist with this Id");
        break;
      default:
        throw new Error("Invalid type");
    }
    sql = `SELECT id FROM ${shortlistTbl} WHERE school_id = ? AND us_id = ? AND usertype = ? and c_id=? LIMIT 1`;
    result = await dbQuery(sql, [school_id, us_id, type,courseid]);
    if (result.length) {
      // throw new Error(
      //   (type === SCL_STUDENT ? "School" : "College") + " already shortlisted"
      // );
      return false;
    }
    return true; // not shortlisted
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const getBuyerInstituteInfo = async (id) => {
  try {
    const institute_type = await getBuyersInstituteType(id);
    let [sql, result] = [null, null];
    switch (institute_type) {
      case SCHOOL:
        const sclAttributes = [
          `${schoolTbl}.sid`,
          `${schoolTbl}.school_name`,
          `${schoolTbl}.admission_partner`,
          `${schoolTbl}.school_url`,
          `${schoolTbl}.school_logo`,
        ];
        sql = `SELECT ${sclAttributes.join(
          ", "
        )} FROM ${schoolTbl} WHERE buyer_name = ?`;
        break;
      case COLLEGE:
        const clgAttributes = [
          `${collegeTbl}.e_id`,
          `${collegeTbl}.institute_name`,
          `${collegeTbl}.institution_url`,
        ];
        sql = `SELECT ${clgAttributes.join(
          ", "
        )} FROM ${collegeTbl} WHERE buyer_name = ?`;
        break;
      default:
        throw new Error("Invalid institute type");
    }

    result = await dbQuery(sql, [id]);
    return result;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const getBuyersInstituteType = async (id) => {
  try {
    let [sql, result] = [null, null];
    sql = `SELECT * FROM ${buyerTbl} WHERE us_id = ? LIMIT 1`;
    result = await dbQuery(sql, [id]);
    if (!result[0]) throw new Error("Buyer not found");
    const { college_buyer: type } = result[0];
    const institute_type = type == 1 ? COLLEGE : SCHOOL;
    return institute_type;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkSchoolLeadBelongsToBuyer = async (buyerId, leadId) => {
  try {
    const buyerInstituteInfo = await getBuyerInstituteInfo(buyerId);
    const buyerSchoolUrlIn = buyerInstituteInfo
      .map((info) => JSON.stringify(info.school_url))
      .join(", ");
    let [sql, result] = [null, null];
    sql = `SELECT us_id FROM ${leadTbl} WHERE us_id = ? AND url IN (${buyerSchoolUrlIn})`;
    result = await dbQuery(sql, [leadId]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkGeneralLeadBelongsToBuyer = async (buyerId, leadId) => {
  try {
    const buyerInstituteInfo = await getBuyerInstituteInfo(buyerId);
    const buyerCollegeSidIn = buyerInstituteInfo
      .map((info) => info.sid)
      .join(", ");
    let [sql, result] = [null, null];
    sql = `SELECT s_id FROM ${generalEnquiryTbl} WHERE  s_id = ? AND school_id IN (${buyerCollegeSidIn})`;
    result = await dbQuery(sql, [leadId]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkSchoolGradeFeesExist = async (sid) => {
  try {
    let [sql, result] = [null, null];
    sql = `SELECT id FROM ${schoolGradeFeesTbl} WHERE sid = ? LIMIT 1`;
    result = await dbQuery(sql, [sid]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const getSchoolsBasicDetails = async (sid, isPartner = null) => {
  try {
    let [sql, result] = [null, null];
    let qry = "";
    const attributes = [
      `${schoolTbl}.sid`,
      `${schoolTbl}.school_name`,
      `${schoolTbl}.school_url`,
      `${schoolTbl}.admission_partner`,
      `${schoolTbl}.asc_reg_fee`,
      `${schoolTbl}.school_logo`,
      `${schoolTbl}.about_school`,
    ];
    const insertBody = [sid];
    if (isPartner) {
      qry += ` AND admission_partner = ?`;
      insertBody.push(isPartner);
    }
    sql =
      `SELECT ${attributes.join(", ")} FROM ${schoolTbl} WHERE sid = ?` + qry;
    result = await dbQuery(sql, insertBody);
    return result[0];
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkSchoolAlreadyAddedInCart = async (
  leadId,
  sid = null,
  childId = null,
  cartID = null
) => {
  try {
    let [sql, result] = [null, null];
    let qry = "";
    const attributes = [`${cartTbl}.id`];
    const insertBody = [leadId];
    if (sid) {
      qry += ` AND institute_id = ?`;
      insertBody.push(sid);
    }
    if (childId) {
      qry += ` AND child_id = ?`;
      insertBody.push(childId);
    }
    if (cartID) {
      qry += ` AND id = ?`;
      insertBody.push(cartID);
    }
    sql =
      `SELECT ${attributes.join(
        ", "
      )} FROM ${cartTbl} WHERE 1=1 AND us_id = ?` +
      qry +
      ` LIMIT 1`;
    result = await dbQuery(sql, insertBody);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkChildAlreadyExist = async (childId, belongsToLead = null) => {
  try {
    let [sql, result] = [null, null];
    let qry = "";
    const attributes = [`${childTbl}.id`];
    const insertBody = [childId];
    if (belongsToLead) {
      qry += `AND us_id = ?`;
      insertBody.push(belongsToLead);
    }
    sql =
      `SELECT ${attributes.join(", ")} FROM ${childTbl} WHERE 1=1 AND id = ?` +
      qry;
    result = await dbQuery(sql, insertBody);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkCollegeExistByUrlCourse = async (url, courseId) => {
  try {
    let [sql, result] = [null, null];
    let qry = "";
    const attributes = [`${collegeTbl}.e_id, ${collegeTbl}.institute_url`];
    const insertBody = [url];
    sql =
      `SELECT ${attributes.join(
        ", "
      )} FROM ${collegeTbl} WHERE ${collegeTbl}.institute_url = ?` +
      qry +
      ` LIMIT 1`;
    result = await dbQuery(sql, insertBody);
    if (!result.length) return false;
    if (courseId) {
      const courseAttributes = [`${collegeCourseTbl}.c_id`];
      const insertBody = [courseId, result[0].e_id];
      const courseSql = `SELECT ${courseAttributes.join(
        ", "
      )} FROM ${collegeCourseTbl} WHERE ${collegeCourseTbl}.c_id = ? AND ${collegeCourseTbl}.e_id = ? LIMIT 1`;
      const courseResult = await dbQuery(courseSql, insertBody);
      if (!courseResult.length) return false;
    }
    return true;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const checkSchoolQueryExist = async (queryId) => {
  try {
    let [sql, result] = [null, null];
    sql = `SELECT s_id FROM ${schoolQueryTbl} WHERE s_id = ? LIMIT 1`;
    result = await dbQuery(sql, [queryId]);
    if (result.length) return true;
    return false;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const getCollegeBasicDetails = async (collegeId, isPartner = null) => {
  try {
    let [sql, result] = [null, null];
    let qry = "";
    const attributes = [
      `${collegeTbl}.e_id`,
      `${collegeTbl}.institute_name`,
      `${collegeTbl}.institute_url`,
      `${collegeTbl}.is_partner`,
      `${collegeTbl}.institute_logo`,
      `${collegeTbl}.entrance_fee`,
    ];
    const insertBody = [collegeId];
    if (isPartner) {
      qry += ` AND is_partner = ?`;
      insertBody.push(isPartner);
    }
    sql =
      `SELECT ${attributes.join(", ")} FROM ${collegeTbl} WHERE e_id = ?` + qry;
    result = await dbQuery(sql, insertBody);
    return result[0];
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};

const getSchoolIdBasedOnUrl = async (schoolUrl) => {
  try {
    const queryMap = {
      attributes: [`${schoolTbl}.sid`],
      conditions: [`${schoolTbl}.school_url = ?`],
      parameters: [schoolUrl],
      additional: [`LIMIT 1`],
    }
    const result = await getSchoolDetailsService(queryMap);
    if (!result.length) return false;
    return result[0].sid;
  } catch (error) {
    throw new Error("Some error occured while fetching info" + error);
  }
};




const getNPFCourse = async (eid) => {
  if (!eid) return [];
  try {
    let [sql, result] = [null, null];
    let qry = "";
    const attributes = [
      `${npf_course_master}.e_id`,
      `${npf_course_master}.campus`,
      `${npf_course_master}.course`,
      `${npf_course_master}.specialization`,
      `${npf_course_master}.active`,
    ];
    const insertBody = [eid];
    sql =
    `SELECT ${attributes.join(", ")} FROM ${npf_course_master} WHERE e_id = ?` + qry;
  result = await dbQuery(sql, insertBody);
    return result;
  } catch (error) {
    throw new Error(error);
  }
};


// const getNPFCourse = async (eid) => {
//   try {
//     let [sql, result] = [null, null];
//     let qry = "";
//     const attributes = [
//       `${npf_course_master}.e_id`,
//       `${npf_course_master}.campus`,
//       `${npf_course_master}.course`,
//       `${npf_course_master}.specialization`,
//       `${npf_course_master}.active`,
//     ];
//     const insertBody = [eid];
   
//     sql =
//       `SELECT ${attributes.join(", ")} FROM ${npf_course_master} WHERE e_id = ?` + qry;
//     result = await dbQuery(sql, insertBody);
//     return result[0];
//   } catch (error) {
//     throw new Error("Some error occured while fetching info" + error);
//   }
// };



module.exports = {
  checkLeadAlreadyExist,
  checkBuyerExist,
  checkBuyerSchoolExist,
  checkExportPermission,
  checkCollegeExist,
  checkSchoolShortlistExist,
  checkSchoolExist,
  checkLeadShortlistAlreadyExist,
  checkLeadExistInDatabase,
  checkBuyerInstituteAccess,
  getBuyerInstituteInfo,
  getBuyersInstituteType,
  checkSchoolLeadBelongsToBuyer,
  checkGeneralLeadBelongsToBuyer,
  checkSchoolGradeFeesExist,
  getSchoolsBasicDetails,
  checkSchoolAlreadyAddedInCart,
  checkChildAlreadyExist,
  checkCollegeExistByUrlCourse,
  checkSchoolQueryExist,
  getCollegeBasicDetails,
  getCollegeIdBasedOnUrl,
  getSchoolIdBasedOnUrl,
  getSinglevalueByid,
  getlastinsertidforNPF,
  getotherorchidschoolbycity,
  OpenApplyResponseUpdate,
  NPFResponseUpdate,
  NPFResponseUpdatebytable,
  getNPFCourse,
  getschoolemailbyid
};
