const { course } = require("../constants/course.constant");
const { state } = require("../constants/state.constant");
const { school_type } = require("../constants/school.constant");

const sanitizedUrlFromParams = (url) => {
  let config = [],
  category = "",
  location = "";
  locality = "";
  feerange1 = "";
  feerange2 = "";
  let compare=[];
  if (url.includes("-colleges-in-")) {
    config = url.split("-colleges-in-");
    category = course[config[0]] || config[0];
    location = state[config[1]] || config[1];
    locality = "";
  } else if (url.includes("best-schools-in-")) {
    config = url.split("-in-");
    category = "institute";
    let findlocation = config[1].split("-");
    location = findlocation[findlocation.length - 1];
    locality = config[1].split(`-${location}`)[0];
  } else if (url.includes("-vs-")) {
    config = url.split("-vs-");
    category = "institute";
    config[0]?compare.push(config[0]):null
    config[1]?compare.push(config[1]):null
    config[2]?compare.push(config[2]):null
  } else if (url.includes("inr-")) {
    config = url.split("-");
    category = "institute";
    //feerange = findlocation[findlocation.length - 1]
    //console.log("<<<<<config>>>>>", config[2]);

    let rangelist = [
      {
        range: "2lacs",
        value: "200000",
      },
      {
        range: "3lacs",
        value: "300000",
      },
      {
        range: "4lacs",
        value: "400000",
      },
      {
        range: "5lacs",
        value: "500000",
      },
      {
        range: "6lacs",
        value: "600000",
      },
      {
        range: "7lacs",
        value: "700000",
      },
      {
        range: "8lacs",
        value: "800000",
      },
      {
        range: "9lacs",
        value: "900000",
      },
      {
        range: "10lacs",
        value: "1000000",
      },
      {
        range: "12lacs",
        value: "1200000",
      },
      {
        range: "15lacs",
        value: "1500000",
      },
    ];
    
  
    if(config[1]!=undefined){

      rg1 = rangelist.filter((d) => d.range == config[1]);
      feerange1 = rg1[0].value;
    }


    if(config[2]!=undefined){
      rg2 = rangelist.filter((d) => d.range == config[2]);
      feerange2 = rg2[0].value;
    }

    
    
    


  } else if (url.includes("-schools-in-")) {
    config = url.split("-in-");
    category = school_type[config[0]] || config[0];
    location = state[config[1]] || config[1];
    locality = "";
  } else {
    const newBaseUrl = url
      .replace(/[-/]/g, " ")
      .replace(/\b(college|school)s?\b/gi, "institute")
      .replace(/state/g, "")
      .replace(/\s\s+/g, " ")
      .trim()
      .split(" ");

    if (newBaseUrl.indexOf("in") !== -1) {
      location = newBaseUrl[newBaseUrl.indexOf("in") + 1]; // location after in
      location +=newBaseUrl[newBaseUrl.indexOf("in") + 2]?" "+newBaseUrl[newBaseUrl.indexOf("in") + 2]:''
    }
    category = newBaseUrl[0]; // category before institute
  }

  location = location.replace(/[-/]/g, " ");
  locality = locality.replace(/[-/]/g, " ");
  if (location=='uttar')
  {
    location='Uttar Pradesh'
  }
  else
  {
    location=location
  }
  return {
    location,
    category,
    locality,
    feerange1,
    feerange2,
    compare
  };
};

module.exports = {
  sanitizedUrlFromParams,
};
