const {
  SCHOOL_DETAIL,
  TBL_AWARDS,
  TBL_ACCORDION_CONTENT,
  SC_SCHOOLCITYMASTER,
  SCHOOLTYPE,
  TBL_SCHOOL_GRADE_FEE,
} = require("../../../../models/tables");
const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const {
  getInfrastructureDetails,
} = require("../College/college_details.controller");
const { getSchoolIdBasedOnUrl } = require("../../../../utils/leadAccessCheck");
const {
  getSchoolDetailsService,
  getSchoolAwardsService,
  getSchoolFaqService,
  getSchoolGradeFeeService,
  getsimilarschools,
} = require("../../../../services/school.service");
const {
  getSchoolTypeService,
} = require("../../../../services/master/schoolType.service");

// @desc get details on one school based on url, its for public to view
// @route GET /api/v1/public/school/?url=school-url
// @access PUBLIC
const getSchoolDetailsForPublic = tryCatch(async (req, res) => {
  const { url } = req.query;

  const sid = await getSchoolIdBasedOnUrl(url);
  if (!sid) {
    return res.status(404).json({
      status: "fail",
      message: "School not found",
      data: [],
    });
  }

  const queryMap = {
    attributes: setSchoolAttributes(),
    conditions: [`${SCHOOL_DETAIL}.sid = ?`],
    parameters: [sid],
    additional: [`LIMIT 1`],
    joinTbl: [
      `LEFT JOIN ${SC_SCHOOLCITYMASTER} AS state ON (state.cityId = ${SCHOOL_DETAIL}.state OR state.cityName = ${SCHOOL_DETAIL}.state)`,
      `LEFT JOIN ${SC_SCHOOLCITYMASTER} AS city On (city.cityId = ${SCHOOL_DETAIL}.city OR city.cityName = ${SCHOOL_DETAIL}.city)`,
    ],
  };
  const schoolResult = await getSchoolDetailsService(queryMap);
  if (schoolResult instanceof Error || !schoolResult[0]) {
    return res.status(400).json({
      success: false,
      message: "No data found",
    });
  }

  const schoolDetails = schoolResult.pop();

  // WE WERE HAVING SOME ISSUES REGARDING school_details.school_type as its data was in string
  const schoolTypes = await fixSchoolTypeIssue(schoolDetails.type);
  schoolDetails.type = schoolTypes;

  // get school infrastructure
  const schoolInfra = await getInfrastructureDetails(
    schoolDetails.infrastructure
  );
  schoolDetails.infrastructure = schoolInfra;

  // get school awards
  const queryMapAwards = {
    attributes: [`${TBL_AWARDS}.awd_title`, `${TBL_AWARDS}.awd_descriptipn`],
    conditions: [`${TBL_AWARDS}.e_id = ?`, `${TBL_AWARDS}.is_active = 'Y'`],
    parameters: [sid],
  };
  const schoolRanking = await getSchoolAwardsService(queryMapAwards);
  schoolDetails.awards = schoolRanking;

  // get school faq
  const queryMapFaq = {
    attributes: [
      `${TBL_ACCORDION_CONTENT}.question`,
      `${TBL_ACCORDION_CONTENT}.answer`,
    ],
    conditions: [
      `${TBL_ACCORDION_CONTENT}.org_id = ?`,
      `${TBL_ACCORDION_CONTENT}.active = 'Y'`,
    ],
    parameters: [sid],
  };
  const schoolFaqs = await getSchoolFaqService(queryMapFaq);
  schoolDetails.faq = schoolFaqs;

  // get school faq
  const querymapgradFee = {
    attributes: [
      `${TBL_SCHOOL_GRADE_FEE}.grade`,
      `${TBL_SCHOOL_GRADE_FEE}.fee`,
      `${TBL_SCHOOL_GRADE_FEE}.sort`,
    ],
    conditions: [`${TBL_SCHOOL_GRADE_FEE}.sid = ?`],
    parameters: [sid],
    additional: [`ORDER BY ${TBL_SCHOOL_GRADE_FEE}.sort ASC`],
  };

  const SchoolGradeWiseFee = await getSchoolGradeFeeService(querymapgradFee);
  schoolDetails.gradefee = SchoolGradeWiseFee;

  var sdtype = schoolDetails.type.split(",");
  if (sdtype.length > 0) {
    let qre=''
    for (let i = sdtype.length - 1; i >= 0; i--) {
     // console.log("as",i)
      qre+= `${SCHOOL_DETAIL}.school_type like  '%${sdtype[i]}%'`
      qre+=+ i===0?'':' OR '
    }

    

    const querymapsimilar = {
      attributes: [
        `${SCHOOL_DETAIL}.school_name`,
        `${SCHOOL_DETAIL}.school_url`,
        `${SCHOOL_DETAIL}.school_image`,
        `${SCHOOL_DETAIL}.city`,
        `${SCHOOL_DETAIL}.state`,
      ],
      // conditions: [`(${schoolTypekey})`],
       parameters: [],
      additional: [
        `and (${qre}) and  ${SCHOOL_DETAIL}.city like '%${schoolDetails.city}%'  and ${SCHOOL_DETAIL}.school_url!='${url}'  and ${SCHOOL_DETAIL}.school_image!=''  ORDER BY ${SCHOOL_DETAIL}.admission_partner desc LIMIT 12`,
      ],
    };
    //console.log("querymapsimilar",querymapsimilar)
    const similarschools = await getsimilarschools(querymapsimilar);
   schoolDetails.similarschools = similarschools;
  }

  return res.status(200).json({
    success: true,
    data: schoolDetails,
  });
});



const GetCustomLandingPageContentSchool = tryCatch(async (req, res) => {
  


  // let findschool='Orchids';


  // sql = "SELECT city from `school_detail` WHERE `school_name` like '%Orchids%' and active='Y' group by city order by city asc";
  // result = await dbQuery(sql);
  // if (result.length === 0) errorMsgEmpty("No data found", res);


  // const schoolDetails = result.pop();
  // schoolDetails.similarschools = [{name:"shani verma"}];
  
  // return res.status(200).json({
  //   success: true,
  //   data: schoolDetails,
  // });

 

    


  const queryMap = {};
  queryMap.attributes = [
    `${SCHOOL_DETAIL}.sid`,
    `${SCHOOL_DETAIL}.school_name AS name`,
    `${SCHOOL_DETAIL}.school_url AS url`,
    `${SCHOOL_DETAIL}.school_logo AS logo`,
    `${SCHOOL_DETAIL}.school_image AS mainImg`,
    `${SCHOOL_DETAIL}.school_type AS type`,
    `${SCHOOL_DETAIL}.year AS establish`,
    `${SCHOOL_DETAIL}.full_boarding_fee AS full_boarding_fee`,
    `${SCHOOL_DETAIL}.annual_fee AS annual_fee`,    
    `${SCHOOL_DETAIL}.school_affiliated`,
    `${SCHOOL_DETAIL}.admission_partner AS is_partner`,
    `${SCHOOL_DETAIL}.state`,
    `${SCHOOL_DETAIL}.city`,
  ];

  queryMap.conditions = [];
  queryMap.parameters = [];


  // and active='Y' group by city order by city asc

 

  
  queryMap.conditions.push(
    `active='Y' and  school_name like ?` 
    );
    queryMap.parameters.push(
      `%Orchids%`,
    );


    //SELECT city from `school_detail` WHERE `school_name` like '%Orchids%' and active='Y' group by city order by city asc"
     
   

  const schoolResult = await getSchoolDetailsService(queryMap);
  const sendData = {};
  

  
  sendData.schools = schoolResult;


   sql = "SELECT city from `school_detail` WHERE `school_name` like '%Orchids%' and active='Y' group by city order by city asc";
  result = await dbQuery(sql);
  

  sendData.citylist = result;

  
  return res.status(200).json({
    status: "success",
    data: sendData,
  });




});

const fixSchoolTypeIssue = async (type) => {
  try {
    //shani commented if (type.length === 0 || !type) return [];
    if ((type && type.length === 0) || !type) return [];

    const schoolType = type.split(",");
    const schoolTypeId = [];

    for (let i = schoolType.length - 1; i >= 0; i--) {
      if (Number(schoolType[i]) && Number(schoolType[i]) >= 0) {
        schoolTypeId.push(schoolType.pop());
      } else {
        break;
      }
    }

    if (schoolTypeId.length === 0) return type;

    const queryMap = {
      attributes: [`${SCHOOLTYPE}.name`],
      conditions: [`${SCHOOLTYPE}.school_id IN (${schoolTypeId.join(",")})`],
      parameters: [],
    };

    const result = await getSchoolTypeService(queryMap);

    return Array.from(new Set([...result.map((type) => type.name), ...schoolType])).join(", ");
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getSchoolDetailsForPublic,
  GetCustomLandingPageContentSchool,
  fixSchoolTypeIssue,
};

const setSchoolAttributes = () => {
  const schoolAttributesArr = [];
  const metaAttributes = [
    `${SCHOOL_DETAIL}.metaDescription`,
    `${SCHOOL_DETAIL}.metaKeywords`,
    `${SCHOOL_DETAIL}.pageTitle`,
  ];
  schoolAttributesArr.push(...metaAttributes);
  const schoolAttributes = [
    `${SCHOOL_DETAIL}.sid`,
    `${SCHOOL_DETAIL}.school_name AS name`,
    `${SCHOOL_DETAIL}.school_logo AS logo`,
    `${SCHOOL_DETAIL}.school_image`,
    `${SCHOOL_DETAIL}.address`,
    `city.cityName AS city`,
    `state.cityName AS state`,
    `${SCHOOL_DETAIL}.location`,
    `${SCHOOL_DETAIL}.authorised_by`,
    `${SCHOOL_DETAIL}.counsellor`,
  ];
  schoolAttributesArr.push(...schoolAttributes);
  const schoolAboutAttributes = [
    `${SCHOOL_DETAIL}.about_school AS about`,
    `${SCHOOL_DETAIL}.addmission_process`,
  ];
  schoolAttributesArr.push(...schoolAboutAttributes);
  const schoolKeyStatsAttributes = [
    `${SCHOOL_DETAIL}.school_type AS type`,
    `${SCHOOL_DETAIL}.education_medium`,
    `${SCHOOL_DETAIL}.year AS establish`,
    `${SCHOOL_DETAIL}.school_category`,
    `${SCHOOL_DETAIL}.campus_size`,
    `${SCHOOL_DETAIL}.school_class`,
    `${SCHOOL_DETAIL}.school_affiliated AS approved_by`,
    `${SCHOOL_DETAIL}.str_student_no`,
    `${SCHOOL_DETAIL}.str_teacher_no`,
    `${SCHOOL_DETAIL}.admission_partner AS is_partner`,
  ];
  schoolAttributesArr.push(...schoolKeyStatsAttributes);
  const schoolFeeAttributes = [
    `${SCHOOL_DETAIL}.annual_fee`,
    `${SCHOOL_DETAIL}.estimated_annual_fee`,
    `${SCHOOL_DETAIL}.application_fee`,
    `${SCHOOL_DETAIL}.admission_fee`,
    `${SCHOOL_DETAIL}.security_fee`,
    `${SCHOOL_DETAIL}.other_fee`,
    `${SCHOOL_DETAIL}.tution_fee`,
    `${SCHOOL_DETAIL}.semi_boarding_fee`,
    `${SCHOOL_DETAIL}.full_boarding_fee`,
  ];
  schoolAttributesArr.push(...schoolFeeAttributes);
  const schoolMedaiAttributes = [
    `${SCHOOL_DETAIL}.upload_video1 AS video1`,
    `${SCHOOL_DETAIL}.upload_video2 AS video2`,
    `${SCHOOL_DETAIL}.upload_video3 AS video3`,
    `${SCHOOL_DETAIL}.upload_video4 AS video4`,
    `${SCHOOL_DETAIL}.upload_video5 AS video5`,
    `${SCHOOL_DETAIL}.upload_video6 AS video6`,
    `${SCHOOL_DETAIL}.upload_photo1 AS image1`,
    `${SCHOOL_DETAIL}.upload_photo2 AS image2`,
    `${SCHOOL_DETAIL}.upload_photo3 AS image3`,
    `${SCHOOL_DETAIL}.upload_photo4 AS image4`,
    `${SCHOOL_DETAIL}.upload_photo5 AS image5`,
    `${SCHOOL_DETAIL}.upload_photo6 AS image6`,
  ];
  schoolAttributesArr.push(...schoolMedaiAttributes);
  const schoolInfraAttributes = [
    `${SCHOOL_DETAIL}.infrastructure`,
    `${SCHOOL_DETAIL}.facilities`,
  ];
  schoolAttributesArr.push(...schoolInfraAttributes);
  const schoolExtraFacilitiesAttributes = [
    `${SCHOOL_DETAIL}.school_provide_meal`,
    `${SCHOOL_DETAIL}.cctvsurveillance`,
    `${SCHOOL_DETAIL}.classairconditioned`,
    `${SCHOOL_DETAIL}.str_student_no`,
    `${SCHOOL_DETAIL}.str_teacher_no`,
    `${SCHOOL_DETAIL}.totol_school_strength`,
    `${SCHOOL_DETAIL}.avgstudentperclass`,
    `${SCHOOL_DETAIL}.cocurricular_activities`,
  ];
  schoolAttributesArr.push(...schoolExtraFacilitiesAttributes);
  return schoolAttributesArr;
};
